#!/bin/bash

export SCRIPTS_HOME=$PWD

export DOMAIN_NAME=services.${assembly.id}
if [ $DOMAIN_NAME == "UNSET" ]; then
	echo "Need DOMAIN_NAME environment variable."
	exit 10;
fi

export WEBLOGIC_USER_HOME=${weblogic.home}
if [ $WEBLOGIC_USER_HOME == "UNSET" ]; then
	echo "Need WEBLOGIC_USER_HOME environment variable."
	exit 11;
fi

. ${SCRIPTS_HOME}/${DOMAIN_NAME}.profile

if [ ! -d "${SOFTWARE_DIRECTORY}" ]; then
  mkdir -p $SOFTWARE_DIRECTORY
fi

echo "Downloading the required resources..."
wget --no-clobber --progress=bar --directory-prefix=${SOFTWARE_DIRECTORY} http://vapcpappmhvcm82.tmc.va.gov/tools/java/jdk-7u71-linux-x64.tar.gz
wget --no-clobber --progress=bar --directory-prefix=${SOFTWARE_DIRECTORY} http://vapcpappmhvcm82.tmc.va.gov/tools/appServer/fmw_12.1.3.0.0_wls.jar

${SCRIPTS_HOME}/bin/ossetup.sh

if [ $? == 0 ]; then
	echo "Installing Weblogic Server..."
	${SCRIPTS_HOME}/bin/weblogicInstallation.sh
else 
	echo "OS Setup Step Failed with Exit Code ${?}."
	exit $?
fi

if [ $? == 0 ]; then
    echo "Performing Base Weblogic Domain Configuration..."
	${SCRIPTS_HOME}/bin/weblogicDomainConfiguration.sh
else 
	echo "Weblogic Installation Step Failed with Exit Code ${?}."
	exit $?
fi

if [ $? == 0 ]; then
	echo "Trying to start WebLogic Node Manager..." 
	${SCRIPTS_HOME}/bin/weblogicNodeManagerStart.sh
else 
	echo "Base WebLogic Domain Configuration Step Failed with Exit Code ${?}."
	exit $?
fi

if [ $? == 0 ]; then
	echo "Trying to start WebLogic Admin Node..."
	${SCRIPTS_HOME}/bin/weblogicAdminServerStart.sh
else 
	echo "Weblogic Node Manager Startup Step Failed with Exit Code ${?}."
	exit $?
fi

if [ $? == 0 ]; then
	echo "Trying to configure domain..."
	${SCRIPTS_HOME}/bin/weblogicManagedServersConfig.sh
else 
	echo "Weblogic Admin Server Startup Step Failed with Exit Code ${?}."
	exit $?
fi

if [ $? == 0 ]; then
	echo "Trying to start the Cluster..."
	${SCRIPTS_HOME}/bin/weblogicClusterStart.sh
else 
	echo "Weblogic Domain Configuration Step Failed with Exit Code ${?}."
	exit $?
fi

if [ $? != 0 ]; then
	echo "Weblogic Cluster Startup Step Failed with Exit Code ${?}."
fi

exit $?;